import React from 'react';

import styles from 'components/Map/controls/PinIconTraceLayout/index.css';

export default function Speeding({ value, is_hard }: { value?: string; is_hard?: boolean }) {
    return (
        <div className={`${styles.speeding} ${styles.hovered} ${is_hard ? styles.is_hard : ''}`}>
            <svg
                width="78"
                height="44"
                viewBox="0 0 78 44"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
            >
                <g>
                    <path
                        className={styles.stroke}
                        d="M10 13.3636C10 10.9537 11.9537 9 14.3636 9H63.6364C66.0463 9 68 10.9537 68 13.3636V24.8469C68 27.2569 66.0463 29.2105 63.6364 29.2105H44.8288C43.5324 29.2105 42.3031 29.787 41.4741 30.7836L39.6304 33L37.7868 30.7836C36.9578 29.787 35.7285 29.2105 34.4321 29.2105H14.3636C11.9537 29.2105 10 27.2569 10 24.8469V13.3636Z"
                        fill="white"
                    />
                    <text
                        fill="#FF4E4E"
                        y="23"
                        x="39"
                        fontSize="13px"
                        textAnchor="middle"
                        className={styles.fill}
                    >
                        {value}
                    </text>
                </g>
            </svg>
        </div>
    );
}
