import React from 'react';

import { ICarInfo } from 'utils/car/types';
import { IconTraceType, IPinIconTraceLayout } from 'utils/map/trace/types';

import { GPSPinIconLayout } from 'components/Map/controls/GPSPinIconLayout';
import Speeding from 'components/Map/controls/PinIconTraceLayout/Speeding';

import EventCommon from 'components/Map/controls/PinIconTraceLayout/common.component.svg';
import Event from 'components/Map/controls/PinIconTraceLayout/event.component.svg';
import Finish from 'components/Map/controls/PinIconTraceLayout/finish.component.svg';
import Start from 'components/Map/controls/PinIconTraceLayout/start.component.svg';

import styles from 'components/Map/controls/PinIconTraceLayout/index.css';

export const PinIconTraceLayout = (props: IPinIconTraceLayout) => {
    let { type, hovered = false, options } = props;
    let className = `${styles.pin_wrapper} ${hovered && styles.hovered}`;
    switch (type) {
        case IconTraceType.START:
            return (
                <div className={className}>
                    <Start />
                </div>
            );
        case IconTraceType.FINISH:
            return (
                <div className={className}>
                    <Finish />
                </div>
            );
        case IconTraceType.CURRENT:
            return (
                <GPSPinIconLayout
                    hovered={hovered}
                    car={{} as ICarInfo}
                />
            );
        case IconTraceType.CAMERA:
        case IconTraceType.AGGRESSION:
        case IconTraceType.ACCELERATION:
        case IconTraceType.BRAKING:
        case IconTraceType.STRAIGHT_LATERAL_ACCELERATION:
        case IconTraceType.TURNING_LATERAL_ACCELERATION:
            return (
                <div className={className}>
                    <Event />
                </div>
            );
        case IconTraceType.EVENT:
            return <div className={className}>{options?.is_hard ? <Event /> : <EventCommon />}</div>;
        case IconTraceType.SPEEDING:
            return (
                <Speeding
                    value={options?.value}
                    is_hard={options?.is_hard}
                />
            );
    }

    return null;
};
