import React from 'react';
import ReactDOMServer from 'react-dom/server';

import { positions, ZOOM_DURATION } from 'components/Map/controls/constants';

import Bound from 'components/Map/controls/bound/bound.component.svg';

import styles from 'components/Map/controls/bound/index.css';
import controlStyles from 'components/Map/controls/index.css';

declare let ymaps: any;

const BOUND_OBJECT_TYPE = 'clusterer';

export const BoundControl = () => {
    return (
        <div className={`${controlStyles.control} ${styles.bound_control}`}>
            <Bound />
        </div>
    );
};

export const buildBoundControl = (map: ymaps.Map) => {
    let ButtonLayout = ymaps.templateLayoutFactory.createClass(ReactDOMServer.renderToString(<BoundControl />));

    let boundControl = new ymaps.control.Button({
        options: {
            layout: ButtonLayout,
        },
    });

    boundControl.events.add(['select', 'deselect'], () => {
        let bounds = map.geoObjects?.getBounds();
        map.geoObjects.each((object) => {
            if (object.options._name === BOUND_OBJECT_TYPE) {
                bounds = object.getBounds();
            }
        });
        bounds && map.setBounds(bounds, { duration: ZOOM_DURATION });
    });

    map.controls.add(boundControl, {
        float: 'none',
        position: {
            bottom: positions.bottom,
            right: positions.right,
        },
    });
};
