import * as React from 'react';
import { Story } from '@storybook/react';

import { badgeSize, Cluster, clusterSize } from 'components/Map/controls/Cluster';

export default { title: 'Maps/Clusters' };

const Template: Story<any> = (args) => <Cluster {...args} />;

export const Large_Cluster_with_empty_badge = Template.bind({});
Large_Cluster_with_empty_badge.args = {
    count: '99',
    warningCars: '0',
    customOptions: { clusterSize: clusterSize.large },
};

export const Large_Cluster_with_badge = Template.bind({});
Large_Cluster_with_badge.args = {
    ...Large_Cluster_with_empty_badge.args,
    warningCars: '11',
};

export const Large_Cluster_with_large_badge = Template.bind({});
Large_Cluster_with_large_badge.args = {
    count: '120',
    warningCars: '999',
    customOptions: {
        clusterSize: clusterSize.large,
        badgeSize: badgeSize.large,
    },
};

export const Common_with_empty_badge = Template.bind({});
Common_with_empty_badge.args = {
    count: '12',
    warningCars: '0',
    customOptions: { clusterSize: clusterSize.common },
};

export const Common_with_badge = Template.bind({});
Common_with_badge.args = {
    count: '12',
    warningCars: '11',
    customOptions: { clusterSize: clusterSize.common },
};
