import * as React from 'react';
import { Story } from '@storybook/react';

import { GPSPinIconLayout } from 'components/Map/controls/GPSPinIconLayout';

export default { title: 'Maps/Pins' };

const Template: Story<any> = (args) => <GPSPinIconLayout {...args} />;

export const Moving_Pin = Template.bind({});
Moving_Pin.args = {
    car: {
        location: { course: 0 },
        telematics: { speed: 1, is_engine_on: true },
    },
};

export const Moving_Pin_rotated_90deg = Template.bind({});
Moving_Pin_rotated_90deg.args = {
    car: {
        location: { course: 90 },
        telematics: { speed: 1, is_engine_on: true },
    },
};

export const Moving_Pin_rotated_135deg = Template.bind({});
Moving_Pin_rotated_135deg.args = {
    car: {
        location: { course: 135 },
        telematics: { speed: 1, is_engine_on: true },
    },
};

export const Stopped_Pin = Template.bind({});
Stopped_Pin.args = {
    car: {
        telematics: { speed: 0, is_engine_on: false },
    },
};

export const Warning_Moving_Pin = Template.bind({});
Warning_Moving_Pin.args = {
    car: {
        location: { course: 0 },
        telematics: { speed: 1, is_engine_on: true },
    },
    isWarning: true,
};

export const Warning_Moving_Pin_rotated_90deg = Template.bind({});
Warning_Moving_Pin_rotated_90deg.args = {
    car: {
        location: { course: 90 },
        telematics: { speed: 1, is_engine_on: true },
    },
    isWarning: true,
};

export const Warning_Moving_Pin_rotated_135deg = Template.bind({});
Warning_Moving_Pin_rotated_135deg.args = {
    car: {
        location: { course: 135 },
        telematics: { speed: 1, is_engine_on: true },
    },
    isWarning: true,
};

export const Warning_Stopped_Pin = Template.bind({});
Warning_Stopped_Pin.args = {
    car: {
        telematics: { speed: 0, is_engine_on: false },
    },
    isWarning: true,
};

export const Engine_off_with_speed = Template.bind({});
Engine_off_with_speed.args = {
    car: {
        telematics: { speed: 10, is_engine_on: false },
    },
    isWarning: true,
};
