import * as React from 'react';
import { Story } from '@storybook/react';

import { IconTraceType } from 'utils/map/trace/types';

import { PinIconTraceLayout } from 'components/Map/controls/PinIconTraceLayout';

export default { title: 'Maps/Trace Pins' };

const Template: Story<any> = (args) => <PinIconTraceLayout {...args} />;

export const Trace_Start_Pin = Template.bind({});
Trace_Start_Pin.args = {
    type: IconTraceType.START,
};

export const Trace_Start_Pin_hovered = Template.bind({});
Trace_Start_Pin_hovered.args = {
    type: IconTraceType.START,
    hovered: true,
};

export const Trace_Finish_Pin = Template.bind({});
Trace_Finish_Pin.args = {
    type: IconTraceType.FINISH,
};

export const Trace_Finish_Pin_hovered = Template.bind({});
Trace_Finish_Pin_hovered.args = {
    type: IconTraceType.FINISH,
    hovered: true,
};

export const Trace_Event_Pin = Template.bind({});
Trace_Event_Pin.args = {
    type: IconTraceType.EVENT,
};

export const Trace_Event_Pin_hovered = Template.bind({});
Trace_Event_Pin_hovered.args = {
    type: IconTraceType.EVENT,
    hovered: true,
};

export const Trace_Event_Pin_hovered_is_hard = Template.bind({});
Trace_Event_Pin_hovered_is_hard.args = {
    type: IconTraceType.EVENT,
    hovered: true,
    options: {
        is_hard: true,
    },
};

export const Trace_Event_Pin_hovered_is_aggression = Template.bind({});
Trace_Event_Pin_hovered_is_aggression.args = {
    type: IconTraceType.AGGRESSION,
    hovered: true,
};

export const Trace_Overspeed_Pin = Template.bind({});
Trace_Overspeed_Pin.args = {
    type: IconTraceType.SPEEDING,
};

export const Trace_Overspeed_Pin_hovered = Template.bind({});
Trace_Overspeed_Pin_hovered.args = {
    type: IconTraceType.SPEEDING,
    hovered: true,
};

export const Trace_Overspeed_Pin_hovered_with_value = Template.bind({});
Trace_Overspeed_Pin_hovered_with_value.args = {
    type: IconTraceType.SPEEDING,
    hovered: true,
    options: {
        value: '73km/h',
    },
};

export const Trace_Overspeed_Pin_hovered_with_value_is_hard = Template.bind({});
Trace_Overspeed_Pin_hovered_with_value_is_hard.args = {
    type: IconTraceType.SPEEDING,
    hovered: true,
    options: {
        value: '99km/h',
        is_hard: true,
    },
};

export const Trace_Current_Pin = Template.bind({});
Trace_Current_Pin.args = {
    type: IconTraceType.CURRENT,
};

export const Trace_Current_Pin_hovered = Template.bind({});
Trace_Current_Pin_hovered.args = {
    type: IconTraceType.CURRENT,
    hovered: true,
};
