import React from 'react';
import ReactDOMServer from 'react-dom/server';

import { positions, ZOOM_DURATION } from 'components/Map/controls/constants';

import Line from 'components/Map/controls/zoom/line.component.svg';
import Minus from 'components/Map/controls/zoom/minus.component.svg';
import Plus from 'components/Map/controls/zoom/plus.component.svg';

import controlsStyles from 'components/Map/controls/index.css';
import styles from 'components/Map/controls/zoom/index.css';

declare let ymaps: any;

export const ZoomControlPlus = () => {
    return (
        <div
            id="zoom_in"
            className={`${styles.zoom_control_item} ${styles.zoom_control_item_top}`}
        >
            <Plus />
        </div>
    );
};
export const ZoomControlMinus = () => {
    return (
        <div
            id="zoom_out"
            className={`${styles.zoom_control_item} ${styles.zoom_control_item_bottom}`}
        >
            <Minus />
        </div>
    );
};

export const ZoomControl = () => {
    return (
        <div className={`${controlsStyles.control} ${styles.zoom_control}`}>
            <ZoomControlPlus />
            <Line className={styles.zoom_line} />
            <ZoomControlMinus />
        </div>
    );
};

export const buildZoomControl = (map) => {
    let ZoomLayout = ymaps.templateLayoutFactory.createClass(ReactDOMServer.renderToString(<ZoomControl />), {
        build: function (this: any) {
            ZoomLayout.superclass.build.call(this);
            this.zoomInCallback = ymaps.util.bind(this.zoomIn, this);
            this.zoomOutCallback = ymaps.util.bind(this.zoomOut, this);

            let zoom_in: any = document.querySelector('#zoom_in') || {};
            let zoom_out: any = document.querySelector('#zoom_out') || {};

            zoom_in?.addEventListener?.('click', this.zoomInCallback);
            zoom_out?.addEventListener?.('click', this.zoomOutCallback);
        },

        clear: function (this: any) {
            let zoom_in: any = document.querySelector('#zoom_in') || {};
            let zoom_out: any = document.querySelector('#zoom_out') || {};
            zoom_in?.removeEventListener?.('click', this.zoomInCallback);
            zoom_out?.removeEventListener?.('click', this.zoomOutCallback);

            ZoomLayout.superclass.clear.call(this);
        },

        zoomIn: function (this: any) {
            map.setZoom(map.getZoom() + 1, {
                checkZoomRange: true,
                duration: ZOOM_DURATION,
            });
        },

        zoomOut: function (this: any) {
            map.setZoom(map.getZoom() - 1, {
                checkZoomRange: true,
                duration: ZOOM_DURATION,
            });
        },
    });

    let zoomControl = new ymaps.control.ZoomControl({
        options: { layout: ZoomLayout },
    });
    map?.controls?.add(zoomControl, {
        float: 'none',
        position: {
            bottom: positions.bottomZoom,
            right: positions.right,
        },
    });
};
