import { RouteComponentProps } from 'react-router-dom';

import { ICarInfo } from 'utils/car/types';
import { IAreaItem } from 'utils/map/area/types';
import { IInitMapProps } from 'utils/map/map/initMap';

import { IBeacon } from 'components/Map/controls/BeaconPinLayout/types';
import { Areas } from 'components/ui/Buttons/AreasButton/AreasWidget';

export interface IMapProps extends IBaseMapProps, RouteComponentProps {
    cars: ICarInfo[];
    beacon?: IBeacon;
    withoutTooltips?: boolean;
    alwaysCarCenter?: boolean;
    showAreas?: {
        [Areas.FORBIDDEN_TO_RIDE]: boolean;
        [Areas.FORBIDDEN_TO_PARK]: boolean;
    };
}

export interface IViolationItem {
    center: number[];
    fc: string;
    is_hard: boolean;
    finish_time: number;
    length: number;
    limit: number;
    peak: number;
    speed: number;
    start_time: number;
    track: number[];
    translated: string;
}

export interface IBaseMapProps {
    options: IInitMapProps;
    disableDrag?: boolean;
    areas?: IAreaItem[];
}
