import React from 'react';

import NotifyItem from 'components/NotificationCenter/NotifyItem';
import NotificationCenterContext, { removeNotification } from 'components/NotificationCenter/store';
import { Direction } from 'components/ui/DescriptionIcon';
import Tooltip from 'components/ui/Tooltip';

import styles from 'components/NotificationCenter/index.css';

export function NotificationCenter({ isPermanent }: { isPermanent?: boolean }) {
    let { notificationsStore, notificationDispatch } = React.useContext(NotificationCenterContext) || {};

    const onClose = (id) => {
        notificationDispatch(removeNotification(id));
    };
    let notifications = notificationsStore?.notifications || [];
    let onboarding = notificationsStore?.onboarding;

    return (
        <>
            {notifications.length ? (
                <div className={styles.notification_center}>
                    {notifications.map((notification) => {
                        return (
                            <NotifyItem
                                description={notification.description}
                                isPermanent={notification.isPermanent || isPermanent}
                                title={notification.title}
                                button={notification.button}
                                iconType={notification.iconType}
                                delay={notification.delay}
                                _id={notification._id}
                                link={notification.link}
                                onClose={onClose.bind(null, notification._id)}
                                key={notification._id}
                            />
                        );
                    })}
                </div>
            ) : null}
            {onboarding ? (
                <div className={styles.oboarding}>
                    <Tooltip
                        title={onboarding.text}
                        description={onboarding.description}
                        direction={Direction.TOP}
                        className={styles.custom_tooltip}
                    />
                </div>
            ) : null}
        </>
    );
}
