import * as React from 'react';
import { useEffect, useReducer } from 'react';
import { HashRouter, Route } from 'react-router-dom';

import { NotificationCenter } from 'components/NotificationCenter/index';
import NotifyItem from 'components/NotificationCenter/NotifyItem';
import NotificationCenterContext, {
    addNotification,
    NotificationReducer,
    setOnboarding,
} from 'components/NotificationCenter/store';
import { NotificationIconType } from 'components/NotificationCenter/types';

const TITLE = 'Notification title';
const LINK_LABEL = 'Notification link label';

export default { title: 'UI/Notification Center' };

const Template = (props) => (
    <HashRouter>
        <Route>
            <NotifyItem
                _id="test"
                onClose={() => {}}
                {...props}
            />
        </Route>
    </HashRouter>
);

export const default_notify = Template.bind({});
default_notify.args = {
    title: TITLE,
};

export const notify_with_action = Template.bind({});
notify_with_action.args = {
    title: TITLE,
    link: {
        label: LINK_LABEL,
        to: '/',
    },
};

const VERY_LONG = `Very very very long long link label`;

export const with_long_title = Template.bind({});
with_long_title.args = {
    title: VERY_LONG,
};

export const with_long_link_label = Template.bind({});
with_long_link_label.args = {
    link: {
        label: VERY_LONG,
        to: '/',
    },
};

export const with_long_title_and_link_label = Template.bind({});
with_long_title_and_link_label.args = {
    title: VERY_LONG,
    link: {
        label: VERY_LONG,
        to: '/',
    },
};

export const error_notify = Template.bind({});
error_notify.args = {
    title: TITLE,
    iconType: NotificationIconType.ERROR,
};

export const permanent_notify_with_description = Template.bind({});
permanent_notify_with_description.args = {
    title: 'Permanent',
    description: VERY_LONG + VERY_LONG,
    isPermanent: true,
    link: {
        label: VERY_LONG,
        to: '/',
    },
    iconType: NotificationIconType.ERROR,
};

const buttonOptions = {
    button: {
        onClick: () => {
            alert('Button');
        },
        label: 'Alert!',
    },
};

export const button_notify = Template.bind({});
button_notify.args = {
    title: VERY_LONG + VERY_LONG,
    isPermanent: true,
    ...buttonOptions,
    iconType: NotificationIconType.DONE,
};

export const NotificationCenterBox = () => {
    const [notificationsStore, notificationDispatch] = useReducer(NotificationReducer, {
        notifications: [
            {
                title: 'DONE',
                iconType: NotificationIconType.DONE,
                _id: '1',
                ...buttonOptions,
            },
            {
                ...permanent_notify_with_description.args,
                _id: '2',
            },
            {
                title: 'Error',
                iconType: NotificationIconType.ERROR,
                _id: '3',
            },
        ],
    });
    useEffect(() => {
        notificationDispatch(addNotification({ title: 'test', isPermanent: true }));
    }, []);

    return (
        <NotificationCenterContext.Provider value={{ notificationsStore, notificationDispatch }}>
            <HashRouter>
                <NotificationCenter isPermanent={true} />
            </HashRouter>
        </NotificationCenterContext.Provider>
    );
};

export const Onboarding = () => {
    const [notificationsStore, notificationDispatch] = useReducer(NotificationReducer, {
        notifications: [],
    });
    useEffect(() => {
        notificationDispatch(
            setOnboarding('Нажмите на карте, чтобы создать новый контур или отредактируйте существующие'),
        );
    }, []);

    return (
        <NotificationCenterContext.Provider value={{ notificationsStore, notificationDispatch }}>
            <NotificationCenter />
        </NotificationCenterContext.Provider>
    );
};
