import React from 'react';

import {
    IInitNotificationsStore,
    INotificationCenterContext,
    INotificationItem,
    NOTIFY_ACTION,
    ONBOARDING_ACTION,
} from 'components/NotificationCenter/types';

export const initNotificationsStore: IInitNotificationsStore = {
    notifications: [],
    onboarding: null,
};

export const NotificationReducer = (
    state: IInitNotificationsStore,
    action: { type: NOTIFY_ACTION | ONBOARDING_ACTION; payload: any },
) => {
    switch (action.type) {
        case NOTIFY_ACTION.ADD:
            return {
                ...state,
                notifications: [...state.notifications, { ...action.payload, _id: new Date().getTime() }],
            };
        case NOTIFY_ACTION.REMOVE:
            return {
                ...state,
                notifications: state.notifications.filter((n) => n._id !== action.payload),
            };
        case ONBOARDING_ACTION.SET:
            return {
                ...state,
                onboarding: { text: action.payload },
            };
        default:
            return state;
    }
};

export const addNotification = ({
    title,
    link,
    button,
    iconType,
    isPermanent,
    description,
}: Partial<INotificationItem>) => {
    return {
        type: NOTIFY_ACTION.ADD,
        payload: { title, link, button, iconType, isPermanent, description, _id: new Date().getTime() },
    };
};

export const removeNotification = (id: string) => {
    return {
        type: NOTIFY_ACTION.REMOVE,
        payload: id,
    };
};

export const setOnboarding = (text) => {
    return {
        type: ONBOARDING_ACTION.SET,
        payload: text,
    };
};

const NotificationCenterContext = React.createContext<INotificationCenterContext | null>(null);
export default NotificationCenterContext;
