export interface INotificationItem {
    title: string;
    link?: INotificationLink;
    iconType?: NotificationIconType;
    button: INotificationButton;
    delay?: number;
    _id: string;
    isPermanent?: boolean;
    description?: string;
}

export interface IOnboardingItem {
    text: string;
    description?: string;
}

export enum NotificationIconType {
    DONE = 'done',
    ERROR = 'error',
}

interface INotificationControl {
    label: string;
}

export interface INotificationLink extends INotificationControl {
    to?: string;
}

export interface INotificationButton extends INotificationControl {
    onClick: () => unknown;
}

export interface INotifyComponentItemProps extends INotificationItem {
    onClose: () => void;
}

export interface IInitNotificationsStore {
    notifications: INotificationItem[];
    onboarding?: IOnboardingItem | null;
}

export interface INotificationCenterContext {
    notificationsStore: IInitNotificationsStore;
    notificationDispatch: any;
}

export enum NOTIFY_ACTION {
    ADD = 'add',
    REMOVE = 'remove',
}

export enum ONBOARDING_ACTION {
    SET = 'set_onboarding',
}
