import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'All cars': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All cars',
        ru: 'Все машины',
        cs: 'Všechny vozy',
    },
    'Average amount of earnings of taxi companies on commission from trips': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Average amount of earnings of taxi companies on commission from trips',
        ru: 'Средняя сумма заработка таксопарков на комиссии с поездок',
        cs: 'Průměrná výše výdělků taxi společností na provizi z cest',
    },
    'Average time spent by a car in active statuses': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Average time spent by a car in active statuses',
        ru: 'Среднее время нахождения авто в активных статусах',
        cs: 'Průměrná doba strávená vozem v aktivních stavech',
    },
    'Average value of all successful orders': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Average value of all successful orders',
        ru: 'Средняя стоимость всех успешных заказов',
        cs: 'Průměrná hodnota všech úspěšných objednávek',
    },
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    'Cars with telematics': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars with telematics',
        ru: 'Машины с телематикой',
        cs: 'Vozy s telematikou',
    },
    'Commission for 1 car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Commission for 1 car',
        ru: 'Комиссия на 1 машину',
        cs: 'Provize za 1 auto',
    },
    'Do not perform SH': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Do not perform SH',
        ru: 'Не выполняют SH',
        cs: 'Neprovádějte SH',
    },
    'GMV for 1 car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'GMV for 1 car',
        ru: 'GMV на 1 машину',
        cs: 'GMV pro 1 vůz',
    },
    'Have a date of issue less than 60 days': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Have a date of issue less than 60 days',
        ru: 'Имеют дату выдачи менее 60 дней',
        cs: 'Mají datum vydání méně než 60 dní',
    },
    Indicator: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Indicator',
        ru: 'Показатель',
        cs: 'Indikátor',
    },
    'Number of cars issued by a specific leasing company': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Number of cars issued by a specific leasing company',
        ru: 'Количество машин, выданных отдельной лизинговой компанией',
        cs: 'Počet vozů vydaných konkrétní leasingovou společností',
    },
    'Percentage of days during which cars appeared in the YT system': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Percentage of days during which cars appeared in the YT system',
        ru: 'Доля дней, в течение которых автомобили появлялись в системе ЯТ',
        cs: 'Procento dní, během kterých se vozy objevily v systému YT',
    },
    Portfolio: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Portfolio',
        ru: 'Портфель',
        cs: 'Portfolio',
    },
    'Supply Hours': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Supply Hours',
        ru: 'Supply Hours',
        cs: 'Zásobovací hodiny',
    },
    'The number of cars that have not worked in the service for a sufficient number of hours over the period': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The number of cars that have not worked in the service for a sufficient number of hours over the period',
        ru: 'Количество автомобилей, не отработавших в сервисе достаточное количество часов за период',
        cs: 'Počet vozů, které nefungovaly ve službě po dostatečný počet hodin během období',
    },
    Utilization: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Utilization',
        ru: 'Сдаваемость',
        cs: 'Využití',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
