import ITableValueType from 'components/types';

export const SH_NORMAL_VALUE = 320;

export const KEY_LINK_MAP = {
    cars_count: {
        all_cars: '/cars',
        telematics_cars: '/cars?telematics=true',
    },
    no_sh: {
        all_cars: '/cars?no_sh=true&fresh_issue_date=-fresh_issue_date_tag',
        telematics_cars: '/cars?no_sh=true&telematics=true&fresh_issue_date=-fresh_issue_date_tag',
    },
    no_mileage: {
        all_cars: '/cars',
        telematics_cars: '/cars?telematics=true',
    },
    SLA_excess: {
        all_cars: '/cars',
        telematics_cars: '/cars?telematics=true',
    },
    fresh_issue_date: {
        all_cars: '/cars?fresh_issue_date=fresh_issue_date_tag',
        telematics_cars: '/cars?telematics=true&fresh_issue_date=fresh_issue_date_tag',
    },
};

export interface IPortfolioValue {
    name: string;
    display_name: string;
    type: ITableValueType;
    all_cars?: { value: any; old_value: any };
    telematics_cars?: { value: any; old_value: any };
}

export interface IPortfolioData {
    score: number;
    portfolio: IPortfolioValue[];
}
