import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'all cars': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'all cars',
        ru: 'все машины',
        cs: 'všechny vozy',
    },
    'All taxi parks': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All taxi parks',
        ru: 'Все таксопарки',
        cs: 'Všechny taxi parky',
    },
    'Average time spent by a car in active statuses': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Average time spent by a car in active statuses',
        ru: 'Среднее время нахождения авто в активных статусах',
        cs: 'Průměrná doba strávená vozem v aktivních stavech',
    },
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    City: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'City',
        ru: 'Город',
        cs: 'Město',
    },
    Commission: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Commission',
        ru: 'Комиссия',
        cs: 'Provize',
    },
    GMV: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'GMV',
        ru: 'GMV',
        cs: 'GMV',
    },
    Moscow: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Moscow',
        ru: 'Москва',
        cs: 'Moskva',
    },
    Scoring: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Scoring',
        ru: 'Скоринг',
        cs: 'Skóre',
    },
    SH: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'SH',
        ru: 'SH',
        cs: 'SH',
    },
    'St. Petersburg': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'St. Petersburg',
        ru: 'Питер',
        cs: 'Petrohrad',
    },
    'Taxi park': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Taxi park',
        ru: 'Таксопарк',
        cs: 'Taxi',
    },
    'The amount of earnings of taxi companies on commission from trips for 1 car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The amount of earnings of taxi companies on commission from trips for 1 car',
        ru: 'Сумма заработка таксопарков на комиссии с поездок на 1 машину',
        cs: 'Výše výdělků taxi společností na provizi z cest na 1 auto',
    },
    'The total cost of all successful orders, including subsidies, discounts, coupons, YT commission for 1 car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The total cost of all successful orders, including subsidies, discounts, coupons, YT commission for 1 car',
        ru: 'Совокупная стоимость всех успешных заказов, включая субсидии, скидки, купоны, комиссию ЯТ на 1 машину',
        cs: 'Celkové náklady na všechny úspěšné objednávky, včetně dotací, slev, kupónů, provizí YT na 1 auto',
    },
    TIN: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'TIN',
        ru: 'ИНН',
        cs: 'DIČ',
    },
    Utilization: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Utilization',
        ru: 'Сдаваемость',
        cs: 'Využití',
    },
    'with telematics': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'with telematics',
        ru: 'с телематикой',
        cs: 's telematikou',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
