import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_PORTFOLIO = 'GET_PORTFOLIO',
    GET_TAXI_PARKS = 'GET_TAXI_PARKS',
}

const PORTFOLIO_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_PORTFOLIO]: {
        api: 'portfolio/get',
        method: RequestHelperMethod.POST,
        cgiObj: {
            model: null,
            city: null,
            dates: null,
            old_dates: null,
        },
    },
    [REQUESTS.GET_TAXI_PARKS]: {
        api: 'taxi_companies/list',
        method: RequestHelperMethod.POST,
        cgiObj: {
            page_size: null,
            page_number: null,
            dates: null,
            old_dates: null,
        },
    },
};

export { PORTFOLIO_REQUESTS, REQUESTS };
