import * as React from 'react';
import { Story } from '@storybook/react';

import { ReportSection } from 'entities/Report/consts/ReportSection';

import ReportCard, { IReportCardProps } from 'components/Reports/ReportCard/index';

export default { title: 'ReportCard' };
const Template: Story<IReportCardProps> = (props) => <ReportCard {...props} />;

export const Empty = Template.bind({});
Empty.args = {
    report: {
        section: '',
    },
};

export const Primary = Template.bind({});
Primary.args = {
    report: {
        section: ReportSection.SIGNALS,
        reportName: 'Report',
        reportDescription: 'Report description',
    },
};

export const Hovered = Template.bind({});
Hovered.args = {
    report: {
        section: ReportSection.SIGNALS,
        reportName: 'Report',
        reportDescription: 'Report description',
    },
};

export const WithLabels = Template.bind({});
WithLabels.args = {
    report: {
        labels: ['Transporter, 9L2 9620', 'Transporter, 9L2 9621'],
        section: ReportSection.SIGNALS,
        reportName: 'Report',
        reportDescription: 'Report description',
    },
};

export const WithoutDescription = Template.bind({});
WithoutDescription.args = {
    report: {
        section: ReportSection.SIGNALS,
        reportName: 'Report',
    },
};

export const WithLongText = Template.bind({});
WithLongText.args = {
    report: {
        section: ReportSection.SIGNALS,
        reportName: 'Very very very very very long report name',
        reportDescription: 'Very very very very very very very long report description',
    },
};

Hovered.parameters = { pseudo: { hover: true } };
