import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Day: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Day',
        ru: 'День',
        cs: 'Den',
    },
    'Delete report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete report',
        ru: 'Удалить отчёт',
        cs: 'Odstranit výkaz',
    },
    Description: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Description',
        ru: 'Описание',
        cs: 'Popis',
    },
    "Don't save changes": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "Don't save changes",
        ru: 'Не сохранять изменения',
        cs: 'Neukládejte změny',
    },
    'Edit report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit report',
        ru: 'Настройка отчёта',
        cs: 'Upravit výkaz',
    },
    'Go to Reports section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to Reports section',
        ru: 'Перейти в раздел «Отчеты»',
        cs: 'Přejít do části Výkazy',
    },
    Month: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Month',
        ru: 'Месяц',
        cs: 'Měsíc',
    },
    'Report name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Report name',
        ru: 'Название отчёта',
        cs: 'Název výkazu',
    },
    'Report was deleted': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Report was deleted',
        ru: 'Отчёт удалён',
        cs: 'Výkaz byl odstraněn',
    },
    'Report was saved': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Report was saved',
        ru: 'Отчёт сохранён',
        cs: 'Výkaz byl uložen',
    },
    Save: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Save',
        ru: 'Сохранить',
        cs: 'Uložit',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    'Save report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save report',
        ru: 'Сохранить отчёт',
        cs: 'Uložit výkaz',
    },
    Week: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Week',
        ru: 'Неделя',
        cs: 'Týden',
    },
    Year: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Year',
        ru: 'Год',
        cs: 'Rok',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
