import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Create your first report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create your first report',
        ru: 'Создайте свой первый отчет',
        cs: 'Vytvořte svůj první výkaz',
    },
    'Filter any table and save as a report. It will appear here.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Filter any table and save as a report. It will appear here.',
        ru: 'Отфильтруйте любую таблицу и сохраните в виде отчета. Он появится здесь.',
        cs: 'Filtrujte libovolnou tabulku a uložte jako výkaz. Zobrazí se zde.',
    },
    'There are no reports on such filters': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There are no reports on such filters',
        ru: 'Нет отчетов по таким фильтрам',
        cs: 'S těmito filtry nejsou žádné výkazy',
    },
    'Try to loosen them up': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Try to loosen them up',
        ru: 'Попробуйте их расслабить',
        cs: 'Pokuste se je uvolnit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
