import React from 'react';

import { Shimmer } from 'shared/ui/Shimmer/Shimmer';

import ReportCard from 'components/Reports/ReportCard';
import { IReport } from 'components/Reports/types';
import ErrorReloadLabel from 'components/ui/ErrorLabel/ErrorReloadLabel';

import { i18n } from 'components/Reports/ReportsContent/index.i18n';

import style from 'components/Reports/ReportsContent/index.css';

interface IReportsContentProps {
    reports: IReport[];
    filteredReports: IReport[];
    isLoading: boolean;
    error: Error | null;
    getReports: () => void;
}

const ReportsContent = ({ reports, filteredReports, isLoading, error, getReports }: IReportsContentProps) => {
    return error ? (
        <div className={style.no_data_message}>
            <ErrorReloadLabel reloadFunction={getReports} />
        </div>
    ) : isLoading ? (
        <div className={style.reports_container}>
            <Shimmer className={style.report_shimmer} />
        </div>
    ) : reports.length ? (
        filteredReports.length ? (
            <div className={style.reports_container}>
                {filteredReports.map((report) => {
                    let { id } = report;

                    return (
                        <ReportCard
                            getReports={getReports}
                            key={id}
                            report={report}
                        />
                    );
                })}
            </div>
        ) : (
            <div className={style.no_data_message}>
                <span className={style.title}>{i18n('There are no reports on such filters')}</span>
                <span className={style.advice}>{i18n('Try to loosen them up')}</span>
            </div>
        )
    ) : (
        <div className={style.no_data_message}>
            <span className={style.title}>{i18n('Create your first report')}</span>
            <span className={style.advice}>{i18n('Filter any table and save as a report. It will appear here.')}</span>
        </div>
    );
};

export default ReportsContent;
