import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Additional options': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Additional options',
        ru: 'Дополнительные опции',
        cs: 'Doplňkové vybavení',
    },
    'Date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and time',
        ru: 'Дата и время',
        cs: 'Datum a čas',
    },
    Deposit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Deposit',
        ru: 'Депозит',
        cs: 'Záloha',
    },
    Driver: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver',
        ru: 'Водитель',
        cs: 'Řidič',
    },
    Duration: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Duration',
        ru: 'Длительность',
        cs: 'Doba trvání',
    },
    'Fuel at finish': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel at finish',
        ru: 'Топливо при завершении',
        cs: 'Stav palivové nádrže na konci',
    },
    'Fuel at start': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel at start',
        ru: 'Топливо в начале',
        cs: 'Stav palivové nádrže na začátku',
    },
    Insurance: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Insurance',
        ru: 'Страхование',
        cs: 'Pojištění',
    },
    Mileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Mileage',
        ru: 'Пробег',
        cs: 'Počet ujetých kilometrů',
    },
    Model: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Model',
        ru: 'Модель',
        cs: 'Model',
    },
    Number: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Number',
        ru: 'Номер',
        cs: 'SPZ',
    },
    'Odometer at finish': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Odometer at finish',
        ru: 'Пробег в конце аренды',
        cs: 'Tacho na konci pronájmu',
    },
    'Odometer at start': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Odometer at start',
        ru: 'Пробег на начало аренды',
        cs: 'Tacho na začátku pronájmu',
    },
    'Pick-up point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Pick-up point',
        ru: 'Место получения',
        cs: 'Místo vyzvednutí',
    },
    'Return point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return point',
        ru: 'Место возврата',
        cs: 'Místo vrácení',
    },
    Score: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Score',
        ru: 'Оценка',
        cs: 'Skóre',
    },
    'Total amount': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total amount',
        ru: 'Общая сумма',
        cs: 'Celková částka',
    },
    Violations: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Violations',
        ru: 'Нарушения',
        cs: 'Přestupky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
