import { isRidesBookingColumnsFlag } from 'utils/isRidesBookingColumnsFlag';
import { showCarDriverInRides } from 'utils/showCarDriverInRides';

import { IHeaderInfo } from 'components/ui/Table/types';

import { i18n } from 'components/Rides/RidesTable/constants.i18n';

export function getRidesTableHeaders(hasDriverColumn: boolean = true): IHeaderInfo[] {
    const RIDES_TABLE_HEADER = [
        { key: 'date_time', displayName: i18n('Date and time') },
        { key: 'car_model', displayName: i18n('Model') },
        { key: 'car_number', displayName: i18n('Number') },
        { key: 'mileage', displayName: i18n('Mileage') },
        { key: 'duration', displayName: i18n('Duration') },
        { key: 'score', displayName: i18n('Score') },
        { key: 'violations', displayName: i18n('Violations') },

        ...(isRidesBookingColumnsFlag()
            ? [
                  { key: 'delivery_location', displayName: i18n('Pick-up point') },
                  { key: 'return_location', displayName: i18n('Return point') },
                  { key: 'mileage_start', displayName: i18n('Odometer at start') },
                  { key: 'mileage_finish', displayName: i18n('Odometer at finish') },
                  { key: 'fuel_tank_level_start', displayName: i18n('Fuel at start') },
                  { key: 'fuel_tank_level_finish', displayName: i18n('Fuel at finish') },
                  { key: 'booking_total', displayName: i18n('Total amount') },
                  { key: 'booking_deposit', displayName: i18n('Deposit') },
                  { key: 'offer_options', displayName: i18n('Additional options') },
                  { key: 'insurance_type', displayName: i18n('Insurance') },
              ]
            : []),
    ];

    if (showCarDriverInRides() && hasDriverColumn) {
        RIDES_TABLE_HEADER.splice(1, 0, { key: 'driver', displayName: i18n('Driver') });
    }

    return RIDES_TABLE_HEADER;
}

export function getDefaultRidesColumn(hasDriverColumn: boolean = true): string[] {
    return getRidesTableHeaders(hasDriverColumn).map((column) => column.key);
}

export const REQUIRED_RIDES_HEADERS = ['date_time', 'car_number'];
