import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Dangerous maneuver': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous maneuver',
        ru: 'Небезопасный  манёвр',
        cs: 'Nebezpečný manévr',
    },
    'Dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous ride',
        ru: 'Опасная поездка',
        cs: 'Nebezpečná jízda',
    },
    'Harsh acceleration': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh acceleration',
        ru: 'Резкое ускорение',
        cs: 'Prudké zrychlení',
    },
    'Harsh braking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh braking',
        ru: 'Резкое торможение',
        cs: 'Prudké brzdění',
    },
    'Harsh lane change': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh lane change',
        ru: 'Резкое перестроение',
        cs: 'Prudká změna jízdního pruhu',
    },
    'Harsh turn': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh turn',
        ru: 'Резкий поворот',
        cs: 'Prudké zatočení',
    },
    Speeding: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Speeding',
        ru: 'Превышение скорости',
        cs: 'Překročení povolené rychlosti',
    },
    'Very dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Very dangerous ride',
        ru: 'Очень опасная поездка',
        cs: 'Velmi nebezpečná jízda',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
