import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Average: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Average',
        ru: 'Среднее',
        cs: 'Průměr',
    },
    Scoring: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Scoring',
        ru: 'Скоринг',
        cs: 'Skóre',
    },
    'This is driving style for the last 200 km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'This is driving style for the last 200 km',
        ru: 'Это стиль вождения на машине за последние 200 км',
        cs: 'Toto je jízdní styl za posledních 200 km',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
