import React from 'react';

import { formatNumber } from 'shared/helpers/formatNumber/formatNumber';

import Informer, { CharType } from 'components/Informer';
import { buildScoringAdditionalData } from 'components/Scoring/ScoringInformer/buildScoringAdditionalData';
import { buildScoringChartOptions } from 'components/Scoring/ScoringInformer/buildScoringChartOptions';

import { i18n } from 'components/Scoring/ScoringInformer/ScoringInformer.i18n';

export interface ScoringInformerProps {
    className?: string;
    type: CharType;
    chartData: any[]; // @todo: write correct type
    chartMedianData: any[]; // @todo: write correct type
    additionalHeaders?: any[]; // @todo: write correct type
    isLoading: boolean;
    hideHeader?: boolean;
}

export const ScoringInformer: React.FC<ScoringInformerProps> = function ScoringInformer({
    className,
    type,
    chartData,
    chartMedianData,
    additionalHeaders,
    isLoading,
    hideHeader,
}) {
    let lastPoint: string | number = Number(chartData?.[chartData.length - 1]?.y) || 0;
    let lastPointLabel = formatNumber(lastPoint, {
        minimumFractionDigits: 1,
        maximumFractionDigits: 1,
    });

    let options = buildScoringChartOptions();
    let additionalDatasets: any[] = [];

    if (chartMedianData.length && chartData.length) {
        let medianSet = chartMedianData?.reduce((p, c) => {
            if (!p[c.x]) {
                p[c.x] = c;
            }

            return p;
        }, {});

        let trimmedAdditionalData = chartData.map((el) => {
            if (!medianSet[el.x]) {
                return { ...el, y: NaN };
            }

            return medianSet[el.x];
        });

        additionalDatasets = [buildScoringAdditionalData({ data: trimmedAdditionalData, label: i18n('Average') })];
    }

    return (
        <Informer
            className={className}
            data={chartData}
            additionalDatasets={additionalDatasets}
            description={i18n('This is driving style for the last 200 km')}
            type={type}
            options={options}
            title={i18n('Scoring')}
            additionalHeaders={additionalHeaders}
            isLoading={isLoading}
            value={lastPointLabel}
            hideHeader={hideHeader}
        />
    );
};
