const getGradient = (ctx, chartArea) => {
    const low = 0;
    const middle = 0.3;
    const high = 0.6;
    const low_color = '#FF3A3A';
    const high_color = '#27AE60';

    let width, height, gradient;
    const chartWidth = chartArea.right - chartArea.left;
    const chartHeight = chartArea.bottom - chartArea.top;
    if (gradient === null || width !== chartWidth || height !== chartHeight) {
        width = chartWidth;
        height = chartHeight;
        gradient = ctx.createLinearGradient(0, chartArea.bottom, 0, chartArea.top);
        gradient.addColorStop(low, low_color);
        gradient.addColorStop(middle, low_color);
        gradient.addColorStop(high, high_color);
    }

    return gradient;
};

export const buildScoringChartOptions = () => {
    const gridColor = 'rgba(173,173,173,0.49)';
    const tension = 0.01;
    const min = 0;
    const max = 11;

    return {
        tension,
        hideLineGradient: true,
        yAxes: {
            grid: {
                color: (context) => {
                    return (context.tick.value === max && 'transparent') || gridColor;
                },
            },
            min,
            max,
            ticks: {
                callback: (value) => {
                    return value < max ? value ?? '' : '';
                },
            },
        },
        borderColor: function (context) {
            const chart = context.chart;
            const { ctx, chartArea } = chart;

            if (!chartArea) {
                return null;
            }

            return getGradient(ctx, chartArea);
        },
        customPadding: true,
    };
};
