import { DAYS_IN_MONTH, ONE_DAY, ONE_SECOND } from 'constants/constants';

import { dateToShortString } from 'utils/dateToShortString';
import { sortInformersDate } from 'utils/informers/sortInformersDate';

interface BuildScoringDataProps {
    tag_details: BuildScoringTagDetails;
}

interface BuildScoringTagDetails {
    rank: number;
    timestamp: number;
}

export function buildScoringData(data: BuildScoringDataProps[]) {
    let days: Record<string, { timestamp: number; value: number }> = {};
    let currentDay = Date.now();

    for (let i = 0; i <= DAYS_IN_MONTH; i++) {
        let timestamp = currentDay - ONE_DAY * i;
        let key = dateToShortString(timestamp);

        days[key] = { timestamp, value: 0 };
    }

    data.forEach(({ tag_details: tag }) => {
        let timestamp = tag.timestamp * ONE_SECOND;
        let key = dateToShortString(timestamp);

        if (days[key]) {
            days[key].value = tag.rank;
        }
    });

    return Object.values(days)
        .sort(sortInformersDate)
        .filter(({ value }) => value)
        .map(({ timestamp, value }) => {
            return {
                x: dateToShortString(timestamp),
                y: value,
            };
        });
}
