import { DAYS_IN_MONTH, ONE_DAY, ONE_SECOND } from 'constants/constants';

import { dateToShortString } from 'utils/dateToShortString';
import { sortInformersDate } from 'utils/informers/sortInformersDate';

interface BuildScoringMedianDataProps {
    median_ranks: BuildScoringMedianRanks[];
}

interface BuildScoringMedianRanks {
    rank: number;
    timestamp: number;
}

export function buildScoringMedianData({ median_ranks }: BuildScoringMedianDataProps) {
    let days: Record<string, { timestamp: number; value: number }> = {};
    let currentDay = Date.now();

    for (let i = 0; i <= DAYS_IN_MONTH; i++) {
        let timestamp = currentDay - ONE_DAY * i;
        let key = dateToShortString(timestamp);

        days[key] = { timestamp, value: 0 };
    }

    median_ranks.forEach((el) => {
        let timestamp = el.timestamp * ONE_SECOND;
        let key = dateToShortString(timestamp);

        if (days[key]) {
            days[key].value = el.rank;
        }
    });

    return Object.values(days)
        .sort(sortInformersDate)
        .filter(({ value }) => value)
        .map(({ timestamp, value }) => {
            return {
                x: dateToShortString(timestamp),
                y: value,
            };
        });
}
