import React, { MutableRefObject, useRef } from 'react';

import { CARS_REQUESTS, REQUESTS } from 'components/Cars/request';

import { RequestHelper } from '../../../../request-helper/src';

interface UseScoringMedianData<T> {
    handler: (data?: any) => T | null;
}

export function useScoringMedianData<T>({
    handler,
}: UseScoringMedianData<T>): [boolean, null | Error, T | null, (props) => void] {
    let [isLoading, setLoading] = React.useState(true);
    let [error, setError] = React.useState(null);
    let [data, setHistoryValues] = React.useState<any>([]);
    let retry = 0;

    const request: MutableRefObject<RequestHelper> = useRef(new RequestHelper({ requestConfigs: CARS_REQUESTS }));

    const getData = (queryParams) => {
        setLoading(true);
        request.current
            .exec(REQUESTS.GET_PARK_STATS, { queryParams })
            .then((response) => {
                setHistoryValues(handler(response));
            })
            .catch((error) => {
                setError(error);

                if (!retry) {
                    getData(queryParams);
                    retry++;
                }
            })
            .finally(() => {
                setLoading(false);
            });
    };

    React.useEffect(() => {
        return () => {
            request.current.abort();
        };
    }, []);

    return [isLoading, error, data, getData];
}
