import * as React from 'react';
import { Story } from '@storybook/react';

import RoleItem from 'components/Settings/SettingsRoles/RoleItem/index';

export default { title: 'Roles Item' };

const Template: Story<any> = (args) => (
    <RoleItem
        {...args}
        onChange={() => {}}
    />
);

export const active_role = Template.bind({});

active_role.args = {
    role: {
        user_id: '1',
        role_id: 'main',
        role_description: 'Роль роль роль',
        is_active: true,
        disabled: false,
    },
};

export const active_role_disabled = Template.bind({});

active_role_disabled.args = {
    role: {
        user_id: '1',
        role_id: 'main',
        role_description: 'Роль роль роль',
        is_active: true,
        disabled: true,
    },
};

export const not_active_role = Template.bind({});

not_active_role.args = {
    role: {
        user_id: '1',
        role_id: 'main',
        role_description: 'Роль роль роль',
        is_active: false,
        disabled: false,
    },
};

export const not_active_role_disabled = Template.bind({});

not_active_role_disabled.args = {
    role: {
        user_id: '1',
        role_id: 'main',
        role_description: 'Роль роль роль',
        is_active: false,
        disabled: true,
    },
};
