import React from 'react';

import { IRoleItem } from 'components/Settings/SettingsRoles/types';
import { Switcher } from 'components/ui/Switcher';

import styles from 'components/Settings/SettingsRoles/RoleItem/index.css';

interface IRoleItemProps {
    role: IRoleItem;
    onChange: () => {};
}

export default function RoleItem(props: IRoleItemProps) {
    let { role_id, role_description, is_active, disabled } = props.role;

    return (
        <div className={`${styles.role_item} ${disabled ? styles.disabled : ''}`}>
            <div className={styles.role_id}>{role_id}</div>
            <div className={styles.role_description}>{role_description}</div>
            <div className={styles.switcher}>
                <Switcher
                    checked={is_active}
                    onChange={props.onChange}
                    disabled={disabled}
                />
            </div>
        </div>
    );
}
