import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Environments: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Environments',
        ru: 'Окружения',
        cs: 'Prostředí',
    },
    'Manage roles': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Manage roles',
        ru: 'Управление ролями',
        cs: 'Správa rolí',
    },
    'Organization affiliation tags': {
        en: 'Organization affiliation tags',
        ru: 'Теги принадлежности к организации',
        cs: '',
    },
    Roles: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Roles',
        ru: 'Роли',
        cs: 'Role',
    },
    'The page will be refreshed after switching': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The page will be refreshed after switching',
        ru: 'После переключения страница обновится',
        cs: 'Stránka se po přepnutí obnoví',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
