import React from 'react';

import { Header } from 'widgets/Header';

import { SettingsHeaderTabs } from 'features/SettingsHeaderTabs';

import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import SettingsRoles from 'components/Settings/SettingsRoles';

import { i18n } from 'components/Settings/index.i18n';

export default function Settings() {
    return (
        <SectionLayout
            header={
                <Header
                    title={i18n('Settings')}
                    tabs={<SettingsHeaderTabs />}
                    withoutBorder
                />
            }
            bodyScroll
        >
            <SettingsRoles />
        </SectionLayout>
    );
}
