import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_ROLES = 'GET_ROLES',
    ACTIVATE = 'ACTIVATE',
    DEACTIVATE = 'DEACTIVATE',
}

const SETTINGS_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_ROLES]: {
        api: 'my/roles/list',
    },

    [REQUESTS.ACTIVATE]: {
        method: RequestHelperMethod.POST,
        api: 'user/roles/activate',
        cgiObj: {
            role_id: null,
            action: 'activate',
            user_id: null,
        },
    },
    [REQUESTS.DEACTIVATE]: {
        method: RequestHelperMethod.POST,
        api: 'user/roles/deactivate',
        cgiObj: {
            role_id: null,
            action: 'deactivate',
            user_id: null,
        },
    },
};

export { SETTINGS_REQUESTS, REQUESTS };
