import React, { useContext } from 'react';

import GlobalTooltipContext from 'contexts/GlobalTooltipContext';

import { useTooltipMouseHandler } from 'hooks/useTooltipMouseHandler';

import { copyToClipboard } from 'utils/copyToClipboard';
import getEnv from 'utils/getEnv';
import { isShowEnvVersion } from 'utils/isShowEnvVersion';

import { Direction } from 'components/ui/DescriptionIcon';

import { i18n } from 'components/SideMenu/EnvVersion/index.i18n';

import styles from 'components/SideMenu/EnvVersion/index.css';

export default function EnvVersion() {
    const versionLabel = `v ${process.env.DM_VERSION}`;

    const componentRef = React.useRef<HTMLDivElement | null>(null);
    useTooltipMouseHandler(componentRef);
    const { setShow, setTooltipOptions } = useContext(GlobalTooltipContext);

    const onClick = () => {
        copyToClipboard(versionLabel).then(() => {
            setShow(true);
            setTooltipOptions({
                title: i18n('Copied'),
                direction: Direction.RIGHT,
                small: true,
            });
        });
    };

    let env = getEnv();

    return (
        (isShowEnvVersion() && (
            <div
                className={styles.component}
                ref={componentRef}
                onClick={onClick}
            >
                <div className={styles.title}>{env}</div>
                <div className={styles.version}>{versionLabel}</div>
            </div>
        )) ||
        null
    );
}
