import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    Dashboard: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dashboard',
        ru: 'Дашборд',
        cs: 'Informační panel',
    },
    Portfolio: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Portfolio',
        ru: 'Портфель',
        cs: 'Portfolio',
    },
    Reports: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Reports',
        ru: 'Отчёты',
        cs: 'Výkazy',
    },
    Rides: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rides',
        ru: 'Поездки',
        cs: 'Jízdy',
    },
    Search: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search',
        ru: 'Поиск',
        cs: 'Vyhledávání',
    },
    Settings: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройки',
        cs: 'Nastavení',
    },
    'Signal Center': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal Center',
        ru: 'Сигнальный центр',
        cs: 'Signální centrum',
    },
    Users: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Users',
        ru: 'Пользователи',
        cs: 'Uživatelé',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
