import * as React from 'react';
import { Story } from '@storybook/react';

import { MenuItemType } from 'components/Content/types';
import { IMenuItemProps, MenuItem } from 'components/SideMenu/MenuItems/MenuItem/index';

export default {
    title: 'Side Menu/Menu Items/Menu Item',
    parameters: {
        layout: 'fullscreen',
        backgrounds: {
            default: 'dark',
            values: [{ name: 'dark', value: '#222222' }],
        },
    },
};
const Template: Story<IMenuItemProps> = (props) => <MenuItem {...props} />;

export const Default = Template.bind({});
Default.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: false,
    onClick: () => {},
};

export const Hovered = Template.bind({});
Hovered.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: false,
    onClick: () => {},
};

export const Focused = Template.bind({});
Focused.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: false,
    onClick: () => {},
};

export const Active = Template.bind({});
Active.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: false,
    onClick: () => {},
};

Hovered.parameters = { pseudo: { hover: true } };
Focused.parameters = { pseudo: { focusVisible: true } };
Active.parameters = { pseudo: { active: true } };

export const Selected = Template.bind({});
Selected.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: true,
    onClick: () => {},
};

export const SelectedHovered = Template.bind({});
SelectedHovered.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: true,
    onClick: () => {},
};

export const SelectedFocused = Template.bind({});
SelectedFocused.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: true,
    onClick: () => {},
};

export const SelectedActive = Template.bind({});
SelectedActive.args = {
    type: MenuItemType.CARS,
    link: '',
    selected: true,
    onClick: () => {},
};

SelectedHovered.parameters = { pseudo: { hover: true } };
SelectedFocused.parameters = { pseudo: { focusVisible: true } };
SelectedActive.parameters = { pseudo: { active: true } };
