import React from 'react';

import { ENTER_KEY_CODE } from 'constants/constants';

import { MenuItemType } from 'components/Content/types';

import { i18n } from 'components/SideMenu/MenuItems/MenuItem/index.i18n';

import Cars from 'components/SideMenu/MenuItems/MenuItem/cars.component.svg';
import Park from 'components/SideMenu/MenuItems/MenuItem/dashboard.component.svg';
import Portfolio from 'components/SideMenu/MenuItems/MenuItem/portfolio.component.svg';
import Reports from 'components/SideMenu/MenuItems/MenuItem/reports.component.svg';
import Rides from 'components/SideMenu/MenuItems/MenuItem/rides.component.svg';
import Search from 'components/SideMenu/MenuItems/MenuItem/search.component.svg';
import Settings from 'components/SideMenu/MenuItems/MenuItem/settings.component.svg';
import Signal from 'components/SideMenu/MenuItems/MenuItem/signal.component.svg';
import Users from 'components/SideMenu/MenuItems/MenuItem/users.component.svg';
import Dashboard from 'shared/ui/Icons/images/grid-24.inline.svg';

import style from 'components/SideMenu/MenuItems/MenuItem/index.css';

export interface IMenuItemProps {
    type: MenuItemType;
    selected: boolean;
    link: string;
    onClick: (link: string) => void;
}

export const MenuItem = (props: IMenuItemProps) => {
    let { type, selected, onClick, link } = props;

    const getItemInfo = () => {
        switch (type) {
            case MenuItemType.DASHBOARD:
                return { component: Dashboard, title: i18n('Dashboard') };
            case MenuItemType.PARK:
                return { component: Park, title: i18n('Dashboard') };
            case MenuItemType.USERS:
                return { component: Users, title: i18n('Users') };
            case MenuItemType.PORTFOLIO:
                return { component: Portfolio, title: i18n('Portfolio') };
            case MenuItemType.REPORTS:
                return { component: Reports, title: i18n('Reports') };
            case MenuItemType.RIDES:
                return { component: Rides, title: i18n('Rides') };
            case MenuItemType.SEARCH:
                return { component: Search, title: i18n('Search') };
            case MenuItemType.SETTINGS:
                return { component: Settings, title: i18n('Settings') };
            case MenuItemType.SIGNAL:
                return { component: Signal, title: i18n('Signal Center') };
            case MenuItemType.CARS:
                return { component: Cars, title: i18n('Cars') };
            default:
                return null;
        }
    };

    const onKeyUp = (event: any) => {
        const code = event.keyCode ? event.keyCode : event.which;
        if (code == ENTER_KEY_CODE) {
            onClick(link);
        }
    };

    let itemInfo = getItemInfo();
    let IconComponent = itemInfo?.component ?? null;

    return (
        <div
            tabIndex={0}
            className={`${style.menu_item} ${selected ? style.selected : ''}`}
            onClick={onClick.bind(null, link)}
            onKeyUp={onKeyUp}
        >
            <IconComponent className={style.menu_item_icon} />
            <div className={style.tooltip}>{itemInfo?.title}</div>
        </div>
    );
};
