import * as React from 'react';

import { IPassportUserInfo } from 'components/Content/types';
import { UserAvatar } from 'components/SideMenu/UserMenu/UserAvatar/index';

import styles from 'components/SideMenu/UserMenu/UserAvatar/index.story.css';

const userInfo: IPassportUserInfo = {
    default_uid: '123',
    accounts: [
        {
            uid: '123',
            defaultEmail: '',
            displayName: {
                name: 'admin',
                firstname: 'Админ',
                lastname: 'Каптюров',
                default_avatar: '100',
            },
        },
    ],
};

export default { title: 'User menu', component: UserAvatar };
export const _default = () => {
    return (
        <div className={styles.content}>
            <UserAvatar userInfo={userInfo} />
        </div>
    );
};

export const _hovered_inactive = () => {
    return (
        <div className={styles.content}>
            <UserAvatar userInfo={userInfo} />
        </div>
    );
};

export const _active = () => {
    return (
        <div className={styles.content}>
            <UserAvatar userInfo={userInfo} />
        </div>
    );
};

export const _hovered_active = () => {
    return (
        <div className={styles.content}>
            <UserAvatar userInfo={userInfo} />
        </div>
    );
};

_hovered_inactive.parameters = { pseudo: { hover: true } };
_hovered_active.parameters = { pseudo: { hover: true } };
