import * as React from 'react';

import { IPassportUserInfo } from 'components/Content/types';

import styles from 'components/SideMenu/UserMenu/UserAvatar/index.css';

export interface IUserAvatarProps {
    userInfo: IPassportUserInfo | null;
    size?: 's' | 'l';
}

const getAvatar = (userInfo) => {
    let account = userInfo?.accounts?.find((account) => {
        return account?.uid === userInfo?.default_uid;
    });
    let { displayName } = account ?? {};
    let { default_avatar = '_' } = displayName ?? {};

    let avatarUrl = `https://avatars.mds.yandex.net/get-yapic/${default_avatar}/islands-retina-small`;

    return { avatarUrl };
};

export const UserAvatar = (props: IUserAvatarProps) => {
    let { avatarUrl } = getAvatar(props.userInfo);

    return (
        <div className={`${styles.userPhoto} ${props.size ? styles[props.size] : ''}`}>
            {props.userInfo ? (
                <img
                    alt="user-photo"
                    src={avatarUrl ?? ''}
                />
            ) : null}
        </div>
    );
};
