import * as React from 'react';

import { IUserAvatarProps, UserAvatar } from 'components/SideMenu/UserMenu/UserAvatar';

import style from 'components/SideMenu/UserMenu/UserInteractiveAvatar/index.css';

interface IUserInteractiveAvatarProps extends IUserAvatarProps {
    showWidget: () => void;
    isWidgetShowing: boolean;
}

export const UserInteractiveAvatar = React.forwardRef(
    (props: IUserInteractiveAvatarProps, ref: React.MutableRefObject<HTMLDivElement | null>) => {
        let { showWidget } = props;

        return (
            <div
                onClick={showWidget}
                className={style.user_interactive_avatar}
                ref={ref}
            >
                <UserAvatar
                    userInfo={props.userInfo}
                    size={props.size ?? 's'}
                />
            </div>
        );
    },
);
