import * as React from 'react';

import { IPassportUserInfo } from 'components/Content/types';
import { UserAvatar } from 'components/SideMenu/UserMenu/UserAvatar';

import styles from 'components/SideMenu/UserMenu/UserMenuWidget/AccountInfo/index.css';

interface IAccountInfoProps {
    userInfo: IPassportUserInfo | null;
}

export const AccountInfo = (props: IAccountInfoProps) => {
    let { userInfo } = props;

    let userName = '';
    let defaultEmail = '';

    if (userInfo && userInfo.data) {
        defaultEmail = userInfo.data.email;
        userName = defaultEmail.split('@')[0];
    } else {
        let account = userInfo?.accounts?.find((account) => {
            return account?.uid === userInfo?.default_uid;
        });

        let { displayName } = account ?? {};
        let { firstname, lastname, name } = displayName ?? {};

        userName = `${firstname ? firstname : ''}${lastname ? ` ${lastname}` : ''}` || (name ? name : '');
        defaultEmail = account ? account.defaultEmail : '';
    }

    return (
        <div className={styles.account_info}>
            <UserAvatar
                userInfo={userInfo}
                size="l"
            />
            <div className={styles.contacts}>
                <span className={styles.user_name}>{userName}</span>
                <span className={styles.email}>{defaultEmail}</span>
            </div>
        </div>
    );
};
