import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Are you sure you want to log out?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Are you sure you want to log out?',
        ru: 'Точно хотите выйти из аккаунта?',
        cs: 'Opravdu se chcete odhlásit?',
    },
    No: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'No',
        ru: 'Нет',
        cs: 'Ne',
    },
    'Yes, log out': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, log out',
        ru: 'Да, выйти',
        cs: 'Ano, odhlásit se',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
