import React, { useEffect } from 'react';

import Confirm from 'components/ui/Confirm';

import { i18n } from 'components/SideMenu/UserMenu/UserMenuWidget/LogOutConfirmModal/index.i18n';

interface ILogOutConfirmModalProps {
    onConfirm: () => void;
    onClose: () => void;
}

const LogOutConfirmModal = (props: ILogOutConfirmModalProps) => {
    let { onConfirm, onClose } = props;

    useEffect(() => {}, []);

    return (
        <Confirm
            title={i18n('Are you sure you want to log out?')}
            confirmButtonTitle={i18n('Yes, log out')}
            closeButtonTitle={i18n('No')}
            onConfirm={onConfirm}
            onClose={onClose}
        />
    );
};

export default LogOutConfirmModal;
