import * as React from 'react';
import { useState } from 'react';

import { useOutsideClickHandler } from 'hooks/useOutsideClickHandler';

import { logOut } from 'utils/logOut';

import { IPassportUserInfo } from 'components/Content/types';
import { UserInteractiveAvatar } from 'components/SideMenu/UserMenu/UserInteractiveAvatar';
import UserMenuWidget from 'components/SideMenu/UserMenu/UserMenuWidget';
import LogOutConfirmModal from 'components/SideMenu/UserMenu/UserMenuWidget/LogOutConfirmModal';

interface IUserMenuProps {
    userInfo: IPassportUserInfo | null;
}

export const UserMenu = (props: IUserMenuProps) => {
    const [isWidgetShowing, showWidget] = React.useState<boolean>(false);
    const [isOpenedLogOutConfirm, setIsOpenedLogOutConfirm] = useState<boolean>(false);

    let widgetRef = React.useRef<HTMLDivElement | null>(null);
    let avatarRef = React.useRef<HTMLDivElement | null>(null);
    useOutsideClickHandler(widgetRef, (event) => {
        if (
            !(
                event.target.isEqualNode(widgetRef?.current) ||
                event.target.isEqualNode(avatarRef?.current) ||
                event.target.parentNode.isEqualNode(avatarRef?.current)
            )
        ) {
            showWidget(false);
        }
    });

    const logOutClick = () => {
        setIsOpenedLogOutConfirm(true);
        showWidget(false);
    };

    const onLogOutModalClose = () => {
        setIsOpenedLogOutConfirm(false);
    };

    return (
        <>
            <UserInteractiveAvatar
                isWidgetShowing={isWidgetShowing}
                ref={avatarRef}
                userInfo={props.userInfo}
                showWidget={() => {
                    showWidget((isWidgetShowing) => !isWidgetShowing);
                }}
            />
            {isWidgetShowing ? (
                <UserMenuWidget
                    userInfo={props.userInfo}
                    ref={widgetRef}
                    logOutClick={logOutClick}
                />
            ) : null}
            {isOpenedLogOutConfirm ? (
                <LogOutConfirmModal
                    onClose={onLogOutModalClose}
                    onConfirm={logOut}
                />
            ) : null}
        </>
    );
};
