import * as React from 'react';
import { MemoryRouter } from 'react-router';
import { Story } from '@storybook/react';

import { ISideMenuProps, SideMenu } from 'components/SideMenu/index';

export default {
    title: 'Side Menu',
    parameters: {
        layout: 'fullscreen',
    },
};
const Template: Story<ISideMenuProps> = (props) => (
    <MemoryRouter>
        <SideMenu {...props} />
    </MemoryRouter>
);

export const Default = Template.bind({});
Default.args = {
    isLoading: false,
    userInfo: null,
};
