import React from 'react';
import { Link } from 'react-router-dom';

import { getLang } from 'utils/language/getLang';

import { isVlootkit } from 'shared/helpers/isVlootkit/isVlootkit';

import { IPassportUserInfo } from 'components/Content/types';
import EnvVersion from 'components/SideMenu/EnvVersion';
import { MenuItems } from 'components/SideMenu/MenuItems';
import { UserMenu } from 'components/SideMenu/UserMenu';

import LogoVlootkit from 'components/SideMenu/vlootkit_logo.inline.svg';
import LogoEn from 'components/SideMenu/ya_parks_logo_en.component.svg';
import LogoRu from 'components/SideMenu/ya_parks_logo_ru.component.svg';

import style from 'components/SideMenu/index.css';

export interface ISideMenuProps {
    isLoading: boolean;
    userInfo: IPassportUserInfo | null;
}

export const SideMenu = (props: ISideMenuProps) => {
    let { userInfo } = props;

    return (
        <div className={style.side_menu}>
            {isVlootkit() ? (
                <div className={style.vlogo_container}>
                    <Link to="/">
                        <LogoVlootkit />
                    </Link>
                </div>
            ) : (
                <div className={style.logo_container}>
                    <Link to="/">
                        {getLang() === 'en' ? <LogoEn className={style.logo} /> : <LogoRu className={style.logo} />}
                    </Link>
                </div>
            )}

            <MenuItems />
            <EnvVersion />
            <div className={style.user_info}>
                <UserMenu userInfo={userInfo} />
            </div>
        </div>
    );
};
