import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Basic signals cannot be edited': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Basic signals cannot be edited',
        ru: 'Базовые сигналы нельзя редактировать',
        cs: 'Základní signály nelze upravovat',
    },
    Critical: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Critical',
        ru: 'Критический',
        cs: 'Kritické',
    },
    Disabled: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Disabled',
        ru: 'Выключен',
        cs: 'Vypnuto',
    },
    Enabled: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enabled',
        ru: 'Включен',
        cs: 'Povoleno',
    },
    Level: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Level',
        ru: 'Уровень',
        cs: 'Úroveň',
    },
    Normal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Normal',
        ru: 'Обычный',
        cs: 'Normální',
    },
    Signal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal',
        ru: 'Сигнал',
        cs: 'Signál',
    },
    State: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'State',
        ru: 'Состояние',
        cs: 'Stav',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
