import { buildSignalXLSX } from 'entities/Signal/helpers/buildSignalXLSX/buildSignalXLSX';

import { SIGNALS_TABLE_HEADER } from 'components/Signals/SignalsTable/index';

import { ABORT_ERROR_KEY } from '../../../../request-helper/src';

export const downloadSignalsTableXLSX = async (getSignals) => {
    let nextCarsCursor = null;
    let nextSessionsCursor = null;
    let hasMore = true;
    let signals: any[] = [];

    do {
        let response = await getSignals({ nextCarsCursor, nextSessionsCursor, isMore: hasMore, pageSize: 10000 }).then(
            (response) => {
                if (response.meta !== ABORT_ERROR_KEY) {
                    return response;
                }
            },
        );
        if (response) {
            nextCarsCursor = response.next_cars_cursor;
            signals.push(...(response.formattedSignalsRes ?? []));
            hasMore = response.can_get_more_pages;
            nextSessionsCursor = response.next_sessions_cursor;
        }
    } while (hasMore);

    return {
        table: buildSignalXLSX(signals),
        headers: SIGNALS_TABLE_HEADER,
        name: `signals_${Date.now()}`,
    };
};
