import { EMPTY_DATA, ONE_SECOND } from 'constants/constants';

import { getI18nLocale } from 'utils/language/getI18nLocale';

export const getSessionTime = (start, finish) => {
    if (!start) {
        return EMPTY_DATA;
    }

    const locale = getI18nLocale();

    let startDate = start ? new Date(start * ONE_SECOND) : null;
    let finishDate = finish ? new Date(finish * ONE_SECOND) : null;

    let startDateDay = startDate?.getDate();
    let startDateMonth = startDate?.getMonth();
    let finishDateDay = finishDate?.getDate();
    let finishDateMonth = finishDate?.getMonth();

    let startDateString = startDate
        ? startDate?.toLocaleString(locale, {
              day: 'numeric',
              month: 'short',
              hour: '2-digit',
              minute: '2-digit',
          })
        : EMPTY_DATA;

    let finishDateString = finishDate
        ? startDateDay === finishDateDay && startDateMonth === finishDateMonth
            ? finishDate.toLocaleString(locale, {
                  hour: '2-digit',
                  minute: '2-digit',
              })
            : finishDate.toLocaleString(locale, {
                  day: 'numeric',
                  month: 'short',
                  hour: '2-digit',
                  minute: '2-digit',
              })
        : '...';

    return `${startDateString} — ${finishDateString}`;
};
